/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.log;

import com.ibm.hwmca.fw.util.ByteArray;
import com.ibm.hwmca.fw.util.HexString;
import java.io.Serializable;
import java.util.Date;

public class LogEntryId
implements Serializable,
Cloneable {
    private static final String TRACE_MASKT = "XFRMLEIT";
    private static final String TRACE_MASKF = "XFRMLEIF";
    private static final String TRACE_MASKD = "XFRMLEID";
    private String logId;
    private byte logClass;
    private byte logType;
    private short user;
    private Date timestamp;
    private Long offset;
    private static final boolean DEBUG = false;

    public LogEntryId() {
        this.logId = "log";
        this.logClass = 0;
        this.logType = 0;
        this.user = 0;
        this.timestamp = null;
        this.offset = new Long(0L);
    }

    public LogEntryId(String logId, byte logClass, byte logType, short user, Date timestamp, Long offset) {
        if (logId == null) {
            logId = "log";
        }
        this.logId = logId;
        this.logClass = logClass;
        this.logType = logType;
        this.user = user;
        this.timestamp = timestamp;
        this.offset = offset;
    }

    public LogEntryId(String logId, byte logClass, byte logType, short user, Date timestamp) {
        if (logId == null) {
            logId = "log";
        }
        this.logId = logId;
        this.logClass = logClass;
        this.logType = logType;
        this.user = user;
        this.timestamp = timestamp;
        this.offset = new Long(0L);
    }

    public String getLogId() {
        return this.logId;
    }

    public byte getLogClass() {
        return this.logClass;
    }

    public byte getLogType() {
        return this.logType;
    }

    public short getUser() {
        return this.user;
    }

    public void setUser(short userIn) {
        this.user = userIn;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestampIn) {
        this.timestamp = timestampIn;
    }

    public Long getOffset() {
        return this.offset;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName()).append("[").append(this.getLogId()).append(",0x").append(HexString.toHex(this.getLogClass(), true)).append(HexString.toHex(this.getLogType(), true)).append(HexString.toHex(this.getUser(), true)).append(",").append(this.getOffset()).append(",").append(this.getTimestamp()).append("]");
        return result.toString();
    }

    public String toIdString() {
        StringBuffer result = new StringBuffer(this.getClass().getName()).append("[").append(this.getLogId()).append(",0x").append(HexString.toHex(this.getLogClass(), true)).append(HexString.toHex(this.getLogType(), true)).append(HexString.toHex(this.getUser(), true)).append(",").append(this.getOffset()).append(",").append(this.getTimestamp().getTime()).append("]");
        return result.toString();
    }

    public static LogEntryId buildFromIdString(String logString) {
        String logId = "";
        byte logClass = 0;
        byte logType = 0;
        short user = 0;
        Long offset = new Long(0L);
        Date timestamp = new Date();
        String tempString = logString.substring(logString.indexOf("[") + 1);
        logId = tempString.substring(0, tempString.indexOf(",0x"));
        tempString = tempString.substring(logId.length() + 3);
        String classString = tempString.substring(0, 2);
        String typeString = tempString.substring(2, 4);
        String userString = tempString.substring(4, 8);
        tempString = tempString.substring(9);
        String offsetString = tempString.substring(0, tempString.indexOf(","));
        String timeString = tempString.substring(offsetString.length() + 1);
        timeString = timeString.substring(0, timeString.length() - 1);
        logClass = (byte)ByteArray.extractU8(HexString.toHexBytes(classString), 0);
        logType = (byte)ByteArray.extractU8(HexString.toHexBytes(typeString), 0);
        user = (short)ByteArray.extractU16(HexString.toHexBytes(userString), 0, false);
        offset = new Long(offsetString);
        timestamp = new Date(new Long(timeString));
        return new LogEntryId(logId, logClass, logType, user, timestamp, offset);
    }

    public Object clone() {
        LogEntryId result = null;
        try {
            result = (LogEntryId)super.clone();
        }
        catch (Exception exc) {}
        return result;
    }

    public int hashCode() {
        int result = this.logClass + this.logType + this.user;
        if (this.logId != null) {
            result += this.logId.hashCode();
        }
        if (this.timestamp != null) {
            result += this.timestamp.hashCode();
        }
        return result;
    }

    public boolean equals(Object test) {
        boolean result = false;
        if (test instanceof LogEntryId) {
            boolean bl = result = this.logClass == ((LogEntryId)test).logClass && this.logType == ((LogEntryId)test).logType && this.user == ((LogEntryId)test).user;
            if (this.timestamp == null) {
                result = result && ((LogEntryId)test).timestamp == null;
            } else {
                boolean bl2 = result = result && this.timestamp.equals(((LogEntryId)test).timestamp);
            }
            result = this.logId == null ? result && ((LogEntryId)test).logId == null : result && this.logId.equals(((LogEntryId)test).logId);
        }
        return result;
    }
}

